;
;***********************
;    DEMO DIP SWITCH   *
;     EXPERIMENT 0     *
;***********************

        CPU  "Z80.TBL"
        HOF  "INT8"

        ORG  2000H
BUF:    EQU  3000H
SEG:    EQU  0B9H
LED:    EQU  0BAH
DELAY:  EQU  0FH
SYSCAL: EQU  10H
DIP:    EQU  0A0H

;
;***********************
;     SET PARAMETER    *
;***********************

INIT:   LD   A,80H
        OUT  (0BBH),A        ;ctrl
        LD   C,3FH           ;seg disp  0
        LD   E,C             ;SEG toggle
        IN   A,(DIP)         ;read dipsw 8 first to buf
        LD   (BUF),A

LOOP:   LD   A,C             ;out seg
        OUT  (SEG),A
        LD   A,DELAY         ;delay
        LD   B,80H
        RST  SYSCAL

        IN   A,(DIP)         ;
        LD   (BUF+1),A
        LD   B,A             ;b = new bit
        LD   A,(BUF)         ;old dip
        CP   B
        JR   Z,LOOP1         ;dip not change goto toggle seg
;
;/* dipsw cange find bit change */

        LD   D,0             ;start bit
CHK_0:  LD   L,A             ;save old bit
        AND  1
        LD   H,A
        LD   A,B
        AND  1
        CP   H               ;compare old & new bit
        JR   NZ,CHK_1        ;not equ goto chk_1
;
        INC  D               ;next bit
        LD   A,L
        RRC  A
        RRC  B
        JR   CHK_0

;/* bit change */

CHK_1:  OR   0FEH            ;bit not change = 1
        LD   HL,TAB_SEG      ;find data seg
        LD   C,D
        LD   B,0
        ADD  HL,BC
        LD   C,(HL)
        LD   E,(HL)

        LD   B,A             ;save bit change
        LD   A,D             ;bit = bit 0
        CP   0
        LD   A,B             ;restore bit change
        JR   Z,CHK_3         ;yes goto chk_3
;
;/* get position bit */

CHK_2:  RLC  A
        DEC  D
        JR   NZ,CHK_2

CHK_3:  LD   D,A
        LD   A,(BUF+1)
        AND  D
        CPLA
;
;/* save bit */

        LD   D,8
CHK_4:  RRCA
        DEC  D
        JR   NZ,CHK_4
        OUT  (LED),A
        LD   A,(BUF+1)
        LD   (BUF),A
;
;/* toggle segment */

LOOP1:  LD   A,E
        XOR  C
        LD   C,A
        JR   LOOP
;
;/* data segment 1-8 */

TAB_SEG: DFB  7FH,07H,7DH,6DH
         DFB  66H,4FH,5BH,06H
         END

